/**
 * Composer Builder Function
 * Dynamically builds the reply composer form from scratch
 */

function build_composer(threadId, threadAuthorPk, mode = 'clean') {
    const container = document.getElementById('composer-container') || document.querySelector('.composer-container');
    
    if (!container) {
        console.error('Composer container not found');
        return;
    }
    
    // Clear existing content
    container.innerHTML = '';
    
    // Build the composer HTML
    const composerHTML = `
        <h6 id="replyFormTitle">Reply to Thread</h6>
        <button type="button" id="resetFormBtn" class="btn-close" aria-label="Reset to thread mode"
            style="display: none;"></button>
        <form id="replyForm">
            <div class="mb-3">
                <textarea class="form-control" id="replyContent" rows="4" placeholder="Your reply..."
                    maxlength="5000" required></textarea>
                <div class="form-text">
                    <span id="charCount">0</span>/5000 characters
                </div>
            </div>

            <div class="mb-3">
                <label for="tipAmount" class="form-label">Tip Amount (optional)</label>
                <div class="input-group">
                    <input type="number" class="form-control" id="tipAmount" placeholder="0.00" step="0.001"
                        min="0">
                    <span class="input-group-text">SOL</span>
                </div>
                <div class="form-text">
                    Leave empty for no tip, or enter custom amount
                </div>
            </div>

            <input type="hidden" id="replyTo" value="${threadId}">
            <input type="hidden" id="authorPublicKey" value="${threadAuthorPk}">

            <div class="d-grid gap-2">
                <button type="submit" class="btn btn-primary">
                    Post Reply
                </button>
            </div>
        </form>

        <!-- View Mode Control form (modal) -->
        <div class="modal" id="viewModeModal" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">View Mode</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <input type="radio" class="btn-check btn-sm" name="viewMode" id="modeClean" value="clean" ${mode === 'clean' ? 'checked' : ''}>
                        <label class="btn btn-outline-primary" for="modeClean">Clean</label>

                        <input type="radio" class="btn-check btn-sm" name="viewMode" id="modeBlur" value="blur" ${mode === 'blur' ? 'checked' : ''}>
                        <label class="btn btn-outline-primary" for="modeBlur">Blur</label>

                        <input type="radio" class="btn-check btn-sm" name="viewMode" id="modeRaw" value="raw" ${mode === 'raw' ? 'checked' : ''}>
                        <label class="btn btn-outline-primary" for="modeRaw">Raw</label>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
    `;
    
    // Insert the HTML
    container.innerHTML = composerHTML;
    
    // Return references to key elements for easy access
    return {
        container: container,
        form: document.getElementById('replyForm'),
        replyContent: document.getElementById('replyContent'),
        charCount: document.getElementById('charCount'),
        tipAmount: document.getElementById('tipAmount'),
        replyTo: document.getElementById('replyTo'),
        authorPublicKey: document.getElementById('authorPublicKey'),
        resetFormBtn: document.getElementById('resetFormBtn'),
        replyFormTitle: document.getElementById('replyFormTitle'),
        viewModeModal: document.getElementById('viewModeModal')
    };
}
