// Global Variables
let app = null,
	lastUrlLoaded = null,
	urlMetaData = null,
	traceAll = true, // set to true in console to log all method calls. Only works if traceAllMethodCalls is uncommented.
	urlMetaDataFrame = {
		title: null, 
		description: null, 
		author: null, 
		date: null, 
		image: null, 
		language: null
	};

// Script Injection
const bannedURLPrefixes = [
	'chrome://', 
	'file://', 
	'brave://', 
	'opera://', 
	'vivaldi://', 
	'edge://', 
	'about:', 
	'chrome-extension://', 
	'moz-extension://'
];

// listen for messages from the user's current tab
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
	if(request?.action === 'set_metadata_image'){
		const url = request.url;
		urlMetaData.image = url;
		buildMetaDataForm();
	}else if(request?.action === 'cunext_prime_thread'){
		const thread_id = request?.thread_id || null;
		const url 		= request?.url || null;
		const chat_id 	= request?.chat_id || null;
		app.primeThread(thread_id, url, chat_id);
		// Respond with success
		sendResponse({success: true});
	}
});

function updateURLTable(){
	$('.url_mod_table').each(function(){
		const base_td 	= $(this).find('.base_url_td');
		const base_url 	= base_td.attr('data-base-url');
		var query_parts = [];
		$(this).find('.q_tr').each(function(){
			if($(this).hasClass('disabled')) return '';
			const q_key = $(this).find('.query_key').text();
			const q_val = $(this).find('.query_val').text();
			if(!q_key || !q_val) return '';
			query_parts.push(`${q_key}=${q_val}`);
		});
		query_parts 	= query_parts.length? query_parts.join('&') : '';
		const q_mark	= query_parts.length? '?': '';
		const new_url 	= `${base_url}${q_mark}${query_parts}`.trim();
		base_td.attr('data-url', new_url).empty();
		if(new_url == app.getCurrentURL()){
			base_td.append(`<span class="faded">${new_url}</span>`);
		}else{
			base_td.append(`<span class="success">GO</span>&nbsp;<a href="${new_url}" target="_blank">${new_url}</a>`);
		}
	});
}

function buildMetaDataForm(){
	$('#metadata_form').empty();
	urlMetaData = urlMetaData || {};
	for(const key in urlMetaData){
		const val 	= urlMetaData[key];
		const lbl 	= $(`<span class="chat_info">page ${key}</span>`);
		var inp 	= '';
		if(['favicon','date','language'].indexOf(key) > -1) continue; // skip the favicon
		if(key == 'url'){
			if(val.indexOf('?') > -1){
				// split the url
				const url_split 	= val.split('?');
				const base_url 		= url_split[0];
				const query 		= url_split[1];
				inp 				= $(`<table class="url_mod_table"><tbody><tr><td data-base-url=${base_url} data-url="${val}" class="base_url_td" colspan="3"></td></tr></tbody></table>`);
				const query_params 	= query.split('&');
				for(const param of query_params){
					const param_split = param.split('=');
					const q_key 	= param_split[0];
					const q_val 	= param_split[1];
					const x_icon 	= app.heroicon('trash-solid') || '❌';
					const q_kill	= $(`<a href="#" style="font-size:1.1em;" data-query-key="${q_key}" class="error pull-right">${x_icon}</a>`);
					q_kill.on('click', function(){
						const q_key = $(this).attr('data-query-key');
						const q_tr  = $(`.q_tr[data-query-key="${q_key}"]`);
						if(q_tr.hasClass('disabled')){
							q_tr.removeClass('disabled');
						}else{
							q_tr.addClass('disabled');
						}
						updateURLTable();
					});
					const qtr = $(`<tr class="q_tr" data-query-key="${q_key}" style="text-align:right;opacity:0.6;"><td class="query_key">${q_key}</td><td class="query_val" style="text-align:left;">${q_val}</td></tr>`)
					qtr.find('.query_val').append(q_kill);
					inp.find('tbody').append(qtr);
				}
				inp.find('tbody').append(`<tr>
					<td class="chat_info faded" style="text-align:right;opacity:0.6;" colspan="3">Remove trackers ${app.heroicon('arrow-turn-right-up')}</td>
				</tr>`);
			}else{
				inp = `<span class="chat_info success">${val}</span><br>`;
			}
		}else if(key == 'image'){
			lbl.append('&nbsp;|&nbsp;Drag an image here.');
			inp = $(`<div class="img_drop_zone faint-border"><img class="metadata_img" src="${( val? val: 'https://catsupnorth.com/static/logo.png')}" style="display:inline-block;max-height:6em;height:6em;min-height:6em;min-width:6em;" alt="Drag an image here"></div>`);
		}else if(key == 'description'){
			inp = $(`<textarea data-medadata-key="${key}">${( val? val: '' )}</textarea>`);
			inp.on('keyup', function(){
				const key = $(this).attr('data-medadata-key');
				urlMetaData[key] = $(this).val();
			});
		}else{
			inp = $(`<input type="text" data-medadata-key="${key}" value="${( val? val: '' )}">`);
			inp.on('keyup', function(){
				const key = $(this).attr('data-medadata-key');
				urlMetaData[key] = $(this).val();
			});
		}
		$('#metadata_form').append(lbl,'<br>',inp,'<br>');
		if(key == 'image'){
			inp.off().on('dragover', function (event) {
				event.preventDefault();
				$(this).removeClass('faint-border').addClass('success-border');
			}).on('dragleave', function () {
				$(this).removeClass('success-border').addClass('faint-border');
			}).on('drop', function (event) {
				event.preventDefault();
			
				// Retrieve the dragged content
				const draggedElement = event.originalEvent.dataTransfer.getData('text/html');
				const tempDiv = $('<div>').html(draggedElement);
				var draggedImage = tempDiv.find('img');
			
				if (draggedImage.length) {
					draggedImage = draggedImage.first();
					$(this).find('.metadata_img').attr('src', draggedImage.attr('src')); // Update the image source
					urlMetaData.image = draggedImage.attr('src');
				} else {
					alert('Please drag an image!');
				}
			});
		}
	}
	updateURLTable();
};

function hideNavs(){
	$('.internal_nav').not('#nav-close').slideUp(200);
}

function pingServiceWorker(){
	// Send 'EXTENSION_LOADED' message to the content script
	chrome.runtime.sendMessage({ type: 'EXTENSION_LOADED' }, (response) => {
		if (chrome.runtime.lastError) {
			console.error('Error sending message:', chrome.runtime.lastError);
		}
		return true; // Keep the message channel open for responses
	});
}
	
$('document').ready(function(){

	/* Initialize app state */
	app = new AppState();
	app.applyFontSizeSetting();
	$('#settings_opener').on('click', function(){ hideNavs(); app.buildSettingsForm(); });
	$('#notifications_opener').on('click', function(){
		alert('Coming soon: Notifications!\n\nGet notified about new threads, replies, and updates from your followed users. Stay tuned for this exciting feature!');
	});
	$('#gui').on('scroll', function(){
		const isScrolledToBottom = $(this).scrollTop() + $(this).innerHeight() >= $(this)[0].scrollHeight - 2;
		if(isScrolledToBottom){
			app.clearNewMessages();
			app.skipAutoScroll = false;
			$('#scroll_to_bottom_container').css({display:'none'});
		}else{
			app.skipAutoScroll = true;
			$('#scroll_to_bottom_container').css({display:'block'});
		}
	});

	$('#exit_thread').on('click', function(event){
		event.preventDefault();
		app.setCurrentThreadID(null); // should stop the polling
		app.getThreads();
		$('#chat_input').val('').trigger('keyup');
		pingServiceWorker();
	});

	$('#ext_search').on('keyup', function(){
		const query = $(this).val().toString().toLowerCase();
		if (query.length < 3){
			$('.search_hide').removeClass('search_hide');
			$('.search_show').removeClass('search_show');
			return;
		}
		$('.chat').add('.thread').add('.tree_part').add('.tree_thread').add('.bookmark_container').add('.invoice').add('.notification').each(function(){
			const chat_text = $(this).text().toLowerCase();
			if(chat_text.includes(query)){
				$(this).removeClass('search_hide');
				if($(this).hasClass('tree_part') || $(this).hasClass('tree_thread')) $(this).addClass('search_show');
			}else{
				$(this).addClass('search_hide');
				if($(this).hasClass('tree_part') || $(this).hasClass('tree_thread')) $(this).removeClass('search_show');
			}
		});
	});
	
	// thread lock functionality
	$('#thread_locker').on('click', function(){
		$('#thread_locker').css({display:'none'});
		$('#thread_unlocker').css({display:'inline-block'});
		app.lockThread();
	});

	$('#thread_unlocker').on('click', function(){
		$('#thread_locker').css({display:'inline-block'});
		$('#thread_unlocker').css({display:'none'});
		app.unlockThread();
	});

	$('#thread_bookmarker').on('click',function(){
		alert('Coming soon: Bookmarks!\n\nBookmarks allow you to save and quickly access your favorite threads. Stay tuned for this exciting feature!');
	});

	$('#bookmarks_opener').on('click', function(){
		alert('Coming soon: Bookmarks!\n\nBookmarks allow you to save and quickly access your favorite threads. Stay tuned for this exciting feature!');
	});

	$('#tree_count_container').on('click', function(){
		alert('Coming soon: Thread Trees!\n\nThread Trees allow you to visualize and navigate complex conversations with multiple branches and replies. Stay tuned for this exciting feature!');
	});
	
	// Track when the user's current url changes and load threads for the new page (new tab, new page, etc.)
	var setWebNavListeners = setInterval(() => {
		// app is loaded when page ready.
		if(!app) return; 
		if(!chrome || !chrome.webNavigation) return;
		chrome.webNavigation.onCompleted.addListener((details) => { // Monitor when a user navigates to a new page in the current tab'
			// app is loaded when page ready.
			if(!app) return; 
			chrome.tabs.get(details.tabId, (tab) => {
				// return if tab not active
				if(!tab.active) return;
				if (tab && tab.url && tab.url != lastUrlLoaded){
					app.getThreads(tab.url);
					lastUrlLoaded = tab.url;
					urlMetaData = null;
					$('#chat_input').val('').trigger('keyup');
					pingServiceWorker();
				}
			});
		});

		// Add a listener for sites that use pushState to change the URL without reloading the page.
		chrome.webNavigation.onHistoryStateUpdated.addListener((details) => {
			// app is loaded when page ready.
			if(!app) return; 
			chrome.tabs.get(details.tabId, (tab) => {
				// return if tab not active
				if(!tab.active) return; 
				if (tab && tab.url && tab.url != lastUrlLoaded){
					app.getThreads(tab.url);
					lastUrlLoaded = tab.url;
					urlMetaData = null;
					$('#chat_input').val('').trigger('keyup');
					pingServiceWorker();
				}
			});
		});
		clearInterval(setWebNavListeners);
		setWebNavListeners = null;
	},100);
	chrome.tabs.onActivated.addListener((activeInfo) => { // Listen for navigation on current tab
		// app is loaded when page ready.
		if(!app) return; 
		chrome.tabs.get(activeInfo.tabId, (tab) => {
			// return if tab not active
			if(!tab.active) return;
			if (tab && tab.url && tab.url != lastUrlLoaded){
				app.getThreads(tab.url);
				lastUrlLoaded = tab.url;
				urlMetaData = null;
				$('#chat_input').val('').trigger('keyup');
				pingServiceWorker();
			}
		});
	});
	chrome.tabs.onCreated.addListener((tab) => { // Listen for new tab creation
		// app is loaded when page ready.
		if(!app) return; 
		// return if tab not active
		if(!tab.active) return;
		if (tab && tab.url && tab.url != lastUrlLoaded){
			app.getThreads(tab.url);
			lastUrlLoaded = tab.url;
			urlMetaData = null;
			$('#chat_input').val('').trigger('keyup');
			pingServiceWorker();
		}
	});

	// Listen for messages from the service worker
	chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
		if (request.type === 'PING') {
			sendResponse({ status: 'PONG' });
		}
		return true; // Keep the message channel open for responses
	});

	pingServiceWorker(); // ping the service worker to make sure it's alive.
});