function render_threads(server_url = '', exit_callback = null) {
    $('.thread').each(function() {
        const thread = $(this);
        const skip_link = thread.hasClass('skip-link');
        const go_back = thread.hasClass('go-back');

        // Text fields
        const content = thread.data('content');
        const url = thread.data('url');
        const channel = thread.data('channel');
        const replyCount = thread.data('reply-count');

        // IDs 
        const chatId = thread.data('chat-id');
        const authorPublicKey = thread.data('author-public-key');
        const authorDisplayName = thread.data('author-display-name');
        const datetimeCreated = thread.data('datetime-created');

        // Build HTML
        var replyStr = '';
        if (replyCount && !isNaN(replyCount * 1) && replyCount * 1) {
            replyStr = `<span>
                    <span class="text-muted small">${replyCount}</span>
                    <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" fill="currentColor" class="bi bi-chat-fill" viewBox="0 0 16 16">
                      <path d="M8 15c4.418 0 8-3.134 8-7s-3.582-7-8-7-8 3.134-8 7c0 1.76.743 3.37 1.97 4.6-.097 1.016-.417 2.13-.771 2.966-.079.186.074.394.273.362 2.256-.37 3.597-.938 4.18-1.234A9 9 0 0 0 8 15"/>
                    </svg>
                </span>&nbsp;&nbsp;`;
        }
        var chat_link = `<a href="${server_url}/thread/${chatId}">${chatId}</a>`;
        if (skip_link) {
            chat_link = `<strong>${chatId}</strong>`;
        }
        var go_back_link = '';
        if (go_back) {
            go_back_link = `<a href="/" style="padding-right:10px;">←Home</a>`;

            // TODO: Need to rewrite this so it works with extension and brave browser.

            // var last_url = document.referrer;
            // // if hist.length > 1, and current location is of same origin as hist, then show back link
            // if (last_url && window.location.origin === last_url.origin) {
            //     if (last_url.length > 1) {
            //         go_back_link = `<a href="javascript:history.back()" style="padding-right:10px;">←Back</a>`;
            //     } else {
            //         go_back_link = `<a href="/" style="padding-right:10px;">←Home</a>`;
            //     }
            // } else {
            //     go_back_link = `<a href="/" style="padding-right:10px;">←Home</a>`;
            // }
        }

        thread.empty().append(`
             <small class="text-muted">
                 ${go_back_link}${chat_link} by
                 <a href="${server_url}/profile/${authorPublicKey}" class="ghostly user-profile-link" data-public-key="${authorPublicKey}">${authorDisplayName.trim()}</a>
                 <span class="float-end text-muted">
                    ${replyStr}
                     <small class="text-muted relative-time" data-time="${datetimeCreated}">${datetimeCreated}</small>
                 </span>
             </small>
             <br>
             <span class="thread-content-span">
                 ${channel ? `<span class="badge rounded-pill bg-primary"><a href="${server_url}/profile/${authorPublicKey}?channel=${channel}">${channel}</a></span>` : ''} ${content}
             </span>
             <div class="reaction-container" data-chat-id="${chatId}">
                 <button class="btn btn-sm btn-outline-secondary text-muted" style="opacity:0.5;">
                     ⮝ ...
                  </button>
                 <button class="btn btn-sm btn-outline-secondary text-muted" style="opacity:0.5;">
                     ⮟ ...
                  </button>
             </div>
        `);
        if (url) {
            const link_toggle = $(`<a class="thread-link-toggle" data-chat-id="${chatId}" title="Toggle URL visibility">🔗</a>`);
            link_toggle.on('click', function() {
                const linkContainer = $(this).siblings('.thread-link-container');
                linkContainer.toggle(200);
            });
            thread.find('.thread-content-span').append(
                link_toggle,
                `
                <div class="thread-link-container" style="display:none;" data-chat-id="${chatId}">
                <a href="${url}" target="_blank" rel="noopener noreferrer">${url}</a>
                </div>`
            );
        }
    });

    // Update reactions (requires reactions.js)
    $('.thread').each(function() {
        const chatId = $(this).data('chat-id');
        loadReactions(chatId).then(data => {
            if (data) {
                updateReactionDisplay(chatId, data.reactions, data.userReactions);
            }
        });
    });

    // Add follow links (requires follow.js)
    init_follow_links();
}