const endpoint = '/follow_handler';
function update_follow_links(my_pk, following, server_url = '') {
    const follow_icon = `<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-person-plus" viewBox="0 0 16 16">
              <path d="M6 8a3 3 0 1 0 0-6 3 3 0 0 0 0 6m2-3a2 2 0 1 1-4 0 2 2 0 0 1 4 0m4 8c0 1-1 1-1 1H1s-1 0-1-1 1-4 6-4 6 3 6 4m-1-.004c-.001-.246-.154-.986-.832-1.664C9.516 10.68 8.289 10 6 10s-3.516.68-4.168 1.332c-.678.678-.83 1.418-.832 1.664z"/>
              <path fill-rule="evenodd" d="M13.5 5a.5.5 0 0 1 .5.5V7h1.5a.5.5 0 0 1 0 1H14v1.5a.5.5 0 0 1-1 0V8h-1.5a.5.5 0 0 1 0-1H13V5.5a.5.5 0 0 1 .5-.5"/>
            </svg>`;
    const following_icon = `<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-person-check" viewBox="0 0 16 16">
              <path d="M12.5 16a3.5 3.5 0 1 0 0-7 3.5 3.5 0 0 0 0 7m1.679-4.493-1.335 2.226a.75.75 0 0 1-1.174.144l-.774-.773a.5.5 0 0 1 .708-.708l.547.548 1.17-1.951a.5.5 0 1 1 .858.514M11 5a3 3 0 1 1-6 0 3 3 0 0 1 6 0M8 7a2 2 0 1 0 0-4 2 2 0 0 0 0 4"/>
              <path d="M8.256 14a4.5 4.5 0 0 1-.229-1.004H3c.001-.246.154-.986.832-1.664C4.484 10.68 5.711 10 8 10q.39 0 .74.025c.226-.341.496-.65.804-.918Q8.844 9.002 8 9c-5 0-6 3-6 4s1 1 1 1z"/>
            </svg>`;
    try {
        $('.follow-btn').add('.me-span').remove();
        $('.user-profile-link').each(function() {
            $(this).addClass('follow-link-processing-done');
            const public_key = $(this).data('public-key');
            if (public_key == my_pk) {
                const me_span = $(`<span class="text text-muted small me-span" style="padding-left:6px;" data-public-key="${my_pk}">me</span>`);
                $(this).after(me_span);
                $(this).addClass('me');
                return;
            }
            const is_following = following.includes(public_key);
            const link_text = is_following ? following_icon : '<span class="small"><span class="small">follow</span></span>' + follow_icon;
            const follow_class = is_following ? '' : 'text-muted';
            const follow_link = $(`<a class="follow-btn ${follow_class}" data-public-key="${public_key}" style="padding-left:6px;">${link_text}</a>`);
            follow_link.on('click', function() {
                $(this).animate({ opacity: 0 }, 200);
                const pk = $(this).data('public-key');
                const jwt = localStorage.getItem('jwt');
                if (!jwt) {
                    return;
                }
                const headers = { 'Authorization': `Bearer ${jwt}` };
                $.ajax({
                    url: `${server_url}${endpoint}`,
                    type: 'POST',
                    headers: headers,
                    data: JSON.stringify({ public_key: pk }), // follows and/or unfollows
                    contentType: 'application/json',
                    success: function(data) {
                        update_follow_links((data?.my_pk || null), (data?.following || []));
                    }
                });
            });
            $(this).after(follow_link);
        });
    } catch (e) {
        console.error(e);
    }
}
function init_follow_links(server_url = '') {
    const jwt = localStorage.getItem('jwt');
    if (!jwt) {
        return;
    }
    const headers = { 'Authorization': `Bearer ${jwt}` };
    $.ajax({
        url: `${server_url}${endpoint}`,
        type: 'GET',
        headers: headers,
        success: function(data) {
            try {
                const my_pk = data.my_pk;
                const following = data.following; // list of public keys I follow
                update_follow_links(my_pk, following, server_url);
            } catch (e) {
                console.error(e);
            }
        }
    });
}
function clone_follow_links(server_url = '') {
    const pks = []; // Public keys that require follow links or me spans
    var skipped = 0;
    $('.user-profile-link:not(.follow-link-processing-done)').each(function() {
        const public_key = $(this).data('public-key');
        if (public_key && !pks.includes(public_key)) {
            pks.push(public_key);
        }
    });
    for (const pk of pks) {
        const follow_link = $(`.follow-btn[data-public-key="${pk}"]`);
        const me_span = $(`.me-span[data-public-key="${pk}"]`);
        if (follow_link.length > 0) {
            const clone = follow_link.first().clone();
            $(`.user-profile-link[data-public-key="${pk}"]`).each(function() {
                $(this).after(clone.clone());
                $(this).addClass('follow-link-processing-done');
            });
            continue;
        }
        if (me_span.length > 0) {
            const clone = me_span.first().clone();
            $(`.user-profile-link[data-public-key="${pk}"]`).each(function() {
                $(this).after(clone.clone());
                $(this).addClass('follow-link-processing-done').addClass('me');
            });
            continue;
        }
        skipped += 1;
    }
    if (skipped > 0) {
        init_follow_links(server_url); // New chats have been added dynamically, re-init follow links
    }
}