// Relative time formatting
function getRelativeTime(isoString) {
    const serverNow = new Date(document.getElementById("server_now_utc").value);
    const dt = new Date(isoString);
    const diff = (serverNow - dt) / 1000; // seconds

    if (diff < 30) return "now";
    if (diff < 60) return Math.floor(diff) + "s";
    if (diff < 3600) return Math.floor(diff / 60) + "m";
    if (diff < 86400) return Math.floor(diff / 3600) + "h";
    return Math.floor(diff / 86400) + "d";
}

function formatRelativeTime() {
    // Format all relative timestamps
    $(".relative-time").each(function() {
        const isoTime = $(this).attr("data-time");
        if (isoTime) {
            $(this).empty().append(getRelativeTime(isoTime));
            $(this).attr('title', (new Date(isoTime).toLocaleString()));
        }
    });
}